import { USWDS } from '../uswds/uswds.po';
/**  
 * Home - a simple class used for representing the contact list page of the application for e2e testing.  
 */ 
export class Home {
	getPageName() {
		return 'Home';
	}
/**
 * getURLStr() - an accessor method used to get the web address of the contact list page in the application.
 * @returns String data type.
 */
	getURLStr() {
		return '/';
	}
/**
 * getCssSelStr() - an accessor method used to get the string containing a CSS selector reference of the contact list.
 * @returns String data type.
 */
	getCssSelStr() {
    	return '#logo > em > a';
	}
 /**
 * getGoogleButton() - an accessor method used to get the string containing a CSS selector reference of the contact list.
 * @returns String data type.
 */
	getGoogleButton() {
		return 'body > app-root > div:nth-child(4) > app-home > div > div > div:nth-child(10) > app-link:nth-child(2) > div > button';    
	}

 /**
 * getContactUsButton() - an accessor method used to get the string containing a CSS selector reference of the contact list.
 * @returns String data type.
 */
	getContactUsButton() {
		return 'body > app-root > div:nth-child(4) > app-home > div > div > div:nth-child(10) > app-link:nth-child(1) > div > button';    
	}
 /**
 * getTabOrder() - an accessor method used to get the string containing a CSS selector reference of the home page's tabbing order.
 * @returns Array data type.
 */
	getTabOrder() {
		let uswds = new USWDS();
		let tabOrder:string[] = new Array(uswds.getBody()  //body - start of view
			, uswds.getSkipNav().getCssSelStr()  //SkipNav
			, uswds.getHeader().getInner().getButton().getCssSelStr()  //Banner
			, uswds.getNavbar().getLogo().getCssSelStr()  //Logo
			, uswds.getNavigation().getMenuItem1() //'ePharmacy' Menu Item
			, uswds.getNavigation().getMenuItem1_SubMenuItem1() //ePharmacy (Sub 1)
			, uswds.getNavigation().getMenuItem1_SubMenuItem2()  //ePharmacy (Sub 2)
			, uswds.getNavigation().getMenuItem1_SubMenuItem3()  //ePharmacy (Sub 3)
			, uswds.getNavigation().getMenuItem2()  //'eInsurance' Menu Item
			, uswds.getNavigation().getMenuItem2_SubMenuItem1() //'eInsurance'(Sub 1)
			, uswds.getNavigation().getMenuItem2_SubMenuItem2() //'eInsurance' (Sub 2)
			, uswds.getNavigation().getMenuItem3() //'eBilling' Menu Item
			, uswds.getNavigation().getMenuItem3_SubMenuItem1()  // eBilling (Sub 1)
			, uswds.getNavigation().getMenuItem3_SubMenuItem2()  // eBilling (Sub 2)
			, uswds.getNavigation().getMenuItem3_SubMenuItem3()  // eBilling (Sub 3)
			, uswds.getNavigation().getMenuItem4()  //'ePayments' Menu Item
			, uswds.getNavigation().getMenuItem4_SubMenuItem1()  // ePayments (Sub 1)
			, uswds.getNavigation().getMenuItem5()  //'eAdmin' Menu Item
			, uswds.getNavigation().getMenuItem5_SubMenuItem1() //'eAdmin'(Sub 1)
			, uswds.getNavigation().getMenuItem5_SubMenuItem2() //'eAdmin' (Sub 2)
			, uswds.getNavigation().getSecondaryNavigation().getSearch().getSmallSearchField().getCssSelStr() //Search-field
			, uswds.getNavigation().getSecondaryNavigation().getSearch().getSubmitButton().getCssSelStr() //Search-field-button
			, uswds.getNavigation().getSecondaryNavigation().getSearch().getSearchButton().getCssSelStr() //Search-Button
			, uswds.getNavigation().getSecondaryNavigation().getSearch().getFAQButton().getCssSelStr() //FAQ hyperlink
			, uswds.getNavigation().getSecondaryNavigation().getSearch().getContactUsButton().getCssSelStr()  //Contact-US hyperlink
			, this.getContactUsButton() //Contact-Us Btn
			, this.getGoogleButton() //Google Btn
			, uswds.getNavigation().getFTRItem1()  //FTR - Link 1
			, uswds.getNavigation().getFTRItem2() //FTR - Link 2
			, uswds.getNavigation().getFTRItem3() //FTR - FAQ Link
			, uswds.getNavigation().getFTRItem4() //FTR - Contact-Us Link
			, uswds.getNavigation().getMailTo())//FTR - @Mailto: Link
			//Nothing?
			//Addr Bar of Browser:
		return tabOrder;    
	}
}